package gov.va.vamf.scheduling.varutility.datalayer;


import gov.va.vamf.scheduling.varutility.domain.CoreSetting;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import gov.va.vamf.scheduling.varutility.domain.RequestEligibilityCriteria;
import gov.va.vamf.scheduling.varutility.utils.SpringBasedIntegrationRepo;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;


public class RequestEligibilityCriteriaRepositoryTest  extends SpringBasedIntegrationRepo {

    @Autowired
    RequestEligibilityCriteriaRepository requestEligibilityCriteriaRepository;

    @Before
    public void setup() {
        createRequestEligibilityCriteria();
    }

    @After
    public void tearDown() {
        requestEligibilityCriteriaRepository.deleteAll();

    }

    @Test
    public void testSave() {
        RequestEligibilityCriteria requestEligibilityCriteria = new RequestEligibilityCriteria();
        CoreSettings coreSettings = new CoreSettings();
        CoreSetting coreSetting = new CoreSetting();
        coreSetting.setPatientHistoryDuration(365);
        coreSetting.setPatientHistoryRequired("yes");
        coreSetting.setId("323");
        coreSetting.setTypeOfCare("Primary Care");
        coreSetting.setSubmittedRequestLimit(2);
        coreSettings.add(coreSetting);
        requestEligibilityCriteria.setId("523");
        requestEligibilityCriteria.setRequestSettings(coreSettings);
        RequestEligibilityCriteria saved = requestEligibilityCriteriaRepository.save(requestEligibilityCriteria);
        assertNotNull(saved.getId());
        assertEquals("523", saved.getId());
    }

    @Test
    public void testFindById() {
        RequestEligibilityCriteria requestEligibilityCriteria = requestEligibilityCriteriaRepository.findById("565");
        assertEquals("565", requestEligibilityCriteria.getId());
    }

    @Test
    public void testUpdate() {
        RequestEligibilityCriteria fetched = requestEligibilityCriteriaRepository.findById("565");
        assertNotNull(fetched);
        assertEquals("565", fetched.getId());
        fetched.setModifiedBy("test user");
        RequestEligibilityCriteria updated = requestEligibilityCriteriaRepository.save(fetched);
        assertEquals("565", updated.getId());
        assertEquals("test user", updated.getModifiedBy());
    }

    private void createRequestEligibilityCriteria() {
        RequestEligibilityCriteria requestEligibilityCriteria = new RequestEligibilityCriteria();
        CoreSettings coreSettings = new CoreSettings();
        CoreSetting coreSetting = new CoreSetting();
        coreSetting.setId("777");
        coreSetting.setTypeOfCare("test care 777");
        coreSetting.setPatientHistoryRequired("no");
        coreSetting.setPatientHistoryDuration(365);
        coreSetting.setSubmittedRequestLimit(1);
        coreSettings.add(coreSetting);
        requestEligibilityCriteria.setId("565");
        requestEligibilityCriteria.setRequestSettings(coreSettings);
        requestEligibilityCriteriaRepository.save(requestEligibilityCriteria);
    }

}
